'''
Intention:
Test the function of the HTS ALPHA Laser 
https://revvity-ls.atlassian.net/browse/MMDSUS-2399
Measurement:
The idea is to create a sequence what switch on the laser for a short time and detect the scattered light with the US-PMT at the same time.

Measurement Sequence
vu_measurement_unit.py hat eine Funktion:
    async def LoadHTSAlphaTestOperation(self, op_id, exc_time_ms, det_time_ms, laser_on):
        sequence = self.generator.HTSAlphaTestMeas(exc_time_ms, det_time_ms, laser_on)
        self.resultAddresses[op_id] = range(0,2)
        await self.LoadTriggerSequence(op_id, sequence)

Modification of
hh-PyRunner/pyrunner/PyRunner/virtualunits
/meas_seq_generator.py
Procedure:
Load Testplate with reflective surface (MAP)
Create sequence with fixed parameter
testinit (usfocusmoverposition, Scantable goto well x,y)
upload sequence
trigger sequence laser on
trigger sequence laser off
calculate fraction on/off: 
shall be at certain level
-> Laser ok/nok 


'''   
import asyncio
import sys

import config_enum.scan_table_enum as scan_table_enum
import config_enum.focus_mover_enum as usfm_enum
from predefined_tasks.common.helper import send_to_gc, mini_initialize_instrument, report_path, write_header_to_report
from py_pli.pyexception import UrpcFirmwareException
from py_pli.pylib import VUnits, Measurements, GlobalVar
from pylog.pylogger import PyLogger
from meas_services.instrument import InstrumentService

instrument_service = InstrumentService(hal=VUnits.instance.hal)
meas_unit = VUnits.instance.hal.measurementUnit
plate_door = VUnits.instance.hal.plateDoor
scan_table = VUnits.instance.hal.scan_table
us_focus_mover = VUnits.instance.hal.usLumFocusMover
logger = PyLogger.logger

async def HTS_alpha_laser_check(samples = 2, focus_mover_position = 0, excitation = 10, detection = 1000, relax = 0.2):
    # HTS ALPHA Laser Function Test
    # No Plate or Filter Module required.
    # USLum Module should be installed properly

    # Introduction
    msg = f"Starting Task {sys._getframe().f_code.co_name}..."
    await send_to_gc(msg, False, False)

    # Setup Instrument
    msg = f"Setup Instrument..."
    await send_to_gc(msg, False, False)

    await _pre_test()

    # Run Measurement
    msg = f"Starting Measurement..."
    await send_to_gc(msg, False, False)

    # Start loop
    # Laser on
    laser_signal = await _get_signal(samples, focus_mover_position, excitation, detection, relax)
    await asyncio.sleep(0.2)

    # Laser off
    dark_signal = await _get_signal(samples, focus_mover_position, 0, detection, relax)

    # Calculate Ratio as pass/fail
    if dark_signal == 0:
        signal_value = laser_signal
    else:
        signal_value = int(laser_signal/dark_signal)

    await send_to_gc(f"Laser Signal to Dark Signal: {laser_signal} : {dark_signal} ", False, False)

    await send_to_gc(f"Laser ON/OFF Ratio (>100: Laser is working): {signal_value} ", False, False)

    return(signal_value)

async def HTS_alpha_laser_test_scan( samples = 2, excitation = 10, detection = 1000, focus_mover_start_position = 12, focus_mover_stop_position = 0, step_size = 1.0, relax = 0.2):
    # Testscan to evaluate parameter setting for Check
    # Moves focus mover to focus_mover_start_position and measure,
    # than moves step_size up, measure again and reports on the screen.

    # Introduction    
    msg = f"Starting Task {sys._getframe().f_code.co_name}..."
    await send_to_gc(msg, False, False)

    # Reporting
    my_name = sys._getframe().f_code.co_name
    report = report_path(my_name)

    # Manual Setting of scantable and focus
    # Setup Instrument 
    # await _pre_test(well_x, well_y, focus)

    # User can stop after setup
    if GlobalVar.get_stop_gc():
        msg = f"Script stopped by user"
        await send_to_gc(msg, False, False)
        return "Completed"

    # Start Measurement Loop
    with open(report, "w") as my_report:
        write_header_to_report(my_report)
        msg = f"Test started"
        await send_to_gc(msg, False, False, my_report)
        msg = f"focus_mover_position;laser_signal; dark_signal"
        await send_to_gc(msg, False, False, my_report)

        focus_mover_position = focus_mover_start_position
        while focus_mover_position >= focus_mover_stop_position:
            # Messung mit Laser
            laser_signal = await _get_signal(samples, focus_mover_position, excitation, detection, relax)

            # Messung ohne Laser
            dark_signal = await _get_signal(samples, focus_mover_position, 0, detection, relax)

            msg = f"{focus_mover_position}; {laser_signal}; {dark_signal}"
            await send_to_gc(msg, False, False, my_report)
            focus_mover_position -= step_size

            if GlobalVar.get_stop_gc():
                msg = f"Script stopped by user"
                await send_to_gc(msg, False, False, my_report)
                return "Aborted by User"

    return(f"Test finished")


async def _pre_test():
    msg = f"preparing Test Conditions "
    await send_to_gc(msg, False, False)

    try:
        await mini_initialize_instrument()
        msg = f"mini_initialize done"
        await send_to_gc(msg, False, False)
    except Exception as ex:
        msg = f"_pretest -> mini_initialize failed Exception: {ex}"
        await send_to_gc(msg, True, True)
        GlobalVar.set_stop_gc(True)

    await scan_table.Move(0,0)

    msg = f"preconditions ready"
    return (msg)


async def _get_signal(no_samples = 2, focus_height= 0, exc_time= 10, meas_time = 1000, relax = 0.2):
    # Takes no_samples measurements with 
    # focus_height
    # exc_time
    # meas_time
    # and returns the second value (first value is somehow weird)

    # Focus Mover 
    await us_focus_mover.Move(focus_height)
   
    await Measurements.instance.asusMeas.test_init_al_test(exc_time_ms = exc_time, measTime_ms = meas_time)
    await meas_unit.Set_US_LUM_PMT_HV(True)
    await meas_unit.EnableHTSAlphaLaser(True)
    samples = []
    try:
        for i in range (no_samples):
            _, signals = await Measurements.instance.asusMeas.execute_al_test()
            await asyncio.sleep(relax)
            # debug only: await send_to_gc(f"{signals[0]}", False, False)
            samples.append(signals[0])

    except Exception as ex:
        msg = f"_get_signal -> asusMeas execution failed {ex}"
        await send_to_gc(msg, True, True)
        GlobalVar.set_stop_gc(True)

    # Shut down
    try:
        await Measurements.instance.asusMeas.release()

    except Exception as ex:
        msg = f"_flash_meas -> asusMeas release failed {ex}"
        await send_to_gc(msg, True, True)
        GlobalVar.set_stop_gc(True)

    meas_unit.ClearOperations()

    return(samples[-1])


''' Modifications for https://revvity-ls.atlassian.net/browse/MMDSUS-2399

/Pyrunner/
# virtualunits/vu_measurement_unit.py:
    async def LoadHTSAlphaTestOperation(self, op_id, exc_time_ms, det_time_ms, laser_on):
        # TBD uses Lum FPGA Script
        sequence = self.generator.HTSAlphaTestMeas(exc_time_ms, det_time_ms, laser_on)
        self.resultAddresses[op_id] = range(0,2)
        await self.LoadTriggerSequence(op_id, sequence)

# virtualunits/meas_seq_generator.py:    
    # Test for https://revvity-ls.atlassian.net/browse/MMDSUS-2399
    # 2024-10-09/Kay Struebing, Teemu Kaarevara
    def HTSAlphaTestMeas(self, excTime_ms, measTime_ms, laser_on):
        """
            ResultBuffer after the script:
            Bytes:
            0: PulseCounter value for PMT_USLUM
            1: PulseCounter value for PMT_USLUM

        :param excTime_ms:
        :param measTime_ms:
        :return:
        """
        window_coarse, window_fine = divmod(excTime_ms * 1000, 65536)
        window_coarse = int(window_coarse)
        window_fine = int(window_fine)

        off_window_coarse, off_window_fine = divmod((measTime_ms - excTime_ms) * 1000, 65536)
        off_window_coarse = int(off_window_coarse)
        off_window_fine = int(off_window_fine)

        self.currSequence = []
        self.ClearResultBuffer(relative= False, dword = True, addrReg=0, addr= 0)
        self.TimerWaitAndRestart(100)
        self.PulseCounterControl(channel=MeasurementChannel.US_LUM, cumulative=False, resetCounter=True, resetPresetCounter=True, correctionOn=True)
        if laser_on:
            self.SetSignals(OutputSignal.HTS_Alpha)  # on
        if window_coarse > 0:
            self.Loop(window_coarse)
            self.Loop(65536)
            self.TimerWaitAndRestart(100)
            self.PulseCounterControl(channel=MeasurementChannel.US_LUM, cumulative=True, resetCounter=False, resetPresetCounter=True, correctionOn=False)
            self.LoopEnd()
            self.LoopEnd()
        if window_fine > 0:
            self.Loop(window_fine)
            self.TimerWaitAndRestart(100)
            self.PulseCounterControl(channel=MeasurementChannel.US_LUM, cumulative=True, resetCounter=False, resetPresetCounter=True, correctionOn=False)
            self.LoopEnd()
        self.GetPulseCounterResult(channel=MeasurementChannel.US_LUM, relative=False, resetCounter=True, cumulative=False, dword=True, addrPos=0, resultPos=0)

        if laser_on:
            self.ResetSignals(OutputSignal.HTS_Alpha)  # off

        if off_window_coarse > 0:
            self.Loop(window_coarse)
            self.Loop(65536)
            self.TimerWaitAndRestart(100)
            self.PulseCounterControl(channel=MeasurementChannel.US_LUM, cumulative=True, resetCounter=False, resetPresetCounter=True, correctionOn=False)
            self.LoopEnd()
            self.LoopEnd()
        if off_window_fine > 0:
            self.Loop(window_fine)
            self.TimerWaitAndRestart(100)
            self.PulseCounterControl(channel=MeasurementChannel.US_LUM, cumulative=True, resetCounter=False, resetPresetCounter=True, correctionOn=False)
            self.LoopEnd()
        self.GetPulseCounterResult(channel=MeasurementChannel.US_LUM, relative=False, resetCounter=True, cumulative=False, dword=True, addrPos=0, resultPos=0)

        self.Stop(0)
        return self.currSequence

# meas_services/alphus.py
    class AlphaUsService(MeasurementServiceInterface):
        async def test_init_al_test(self, exc_time_ms = 100, measTime_ms=1000):
            if exc_time == 0:
                laser_on  = 0
            else:
                laser_on = 1
            self.det_time_ms = measTime_ms
            await self.hal.measurementUnit.LoadHTSAlphaTestOperation(self, op_id="HTS_Al_Test", exc_time_ms=exc_time_ms, det_time_ms=measTime_ms, laser_on = laser_on)
            self.op_guid = "HTS_Al_Test"
        
        async def execute(self):

            start_time = time.time()

            # deactivated for HTS Alpha Test!
            #if not self.operation_param.alpha_us_optimization:
            #    x_cur, y_cur = self.hal.scan_table.get_current_position()
            #    await self.hal.scan_table.Move(x_cur, y_cur - self.operation_param.aperture_or_welloffest)


        '''